document.addEventListener('keyup',e =>{
  // if S pressed 
  if(e.code == 'KeyS'){
    const svgData = svg.outerHTML;
    const svgBlob = new Blob([svgData], {type:"image/svg+xml;charset=utf-8"});
    const svgUrl = URL.createObjectURL(svgBlob);
    const downloadLink = document.createElement("a");
    downloadLink.href = svgUrl;
    downloadLink.download = "rendu.svg";
    document.body.appendChild(downloadLink);
    downloadLink.click();
    document.body.removeChild(downloadLink);    
  // }
  // if(e.code == 'KeyP'){
    const svgi=  svg.outerHTML; //`<svg version="1.1" baseProfile="full" width="300" height="200"><rect width="100%" height="100%" fill="red" /> <circle cx="150" cy="100" r="80" fill="green" /> <text x="150" y="125" font-size="60" text-anchor="middle" fill="white">SVG</text></svg>`
    svgToPng(svgi,(imgData)=>{
        // const pngImage = document.createElement('img');
        // document.body.appendChild(pngImage);
        // pngImage.src=imgData;
    });
     function svgToPng(svg, callback) {
        const url = getSvgUrl(svg);
        svgUrlToPng(url, (imgData) => {
            callback(imgData);
            URL.revokeObjectURL(url);
        });
    }
    function getSvgUrl(svg) {
        return  URL.createObjectURL(new Blob([svg], { type: 'image/svg+xml' }));
    }
    function svgUrlToPng(svgUrl, callback) {
        const svgImage = document.createElement('img');

        document.body.appendChild(svgImage);
        svgImage.onload = function () {
            const canvas = document.createElement('canvas');
            canvas.width = svgImage.clientWidth;
            canvas.height = svgImage.clientHeight;
            const canvasCtx = canvas.getContext('2d');
            canvasCtx.drawImage(svgImage, 0, 0);
            const imgData = canvas.toDataURL('image/png');
            const downloadLink = document.createElement("a");
            downloadLink.href = imgData;
            downloadLink.download = "rendu.png";
            document.body.appendChild(downloadLink);
            downloadLink.click();
            document.body.removeChild(downloadLink); 
            document.body.removeChild(svgImage);
            callback(imgData);
        };
        svgImage.src = svgUrl;
     }
    
    
  }

});
