import asyncio
from telethon import TelegramClient, events, functions, types
from telethon.errors import SessionPasswordNeededError
import re
import time

API_ID = YOUR_API_ID
API_HASH = 'YOUR_API_HASH'
PHONE = '+YOUR_NUMBER'

DC_SERVER = {
    'dc_id': 2,
    'ip': '149.154.167.40',
    'port': 443
}

client = TelegramClient('gift_bot_session', API_ID, API_HASH)
client.session.set_dc(DC_SERVER['dc_id'], DC_SERVER['ip'], DC_SERVER['port'])

@client.on(events.NewMessage(pattern=r'\.transfer\s+@?(\w+)\s+(\d+)', outgoing=True))
async def transfer_gifts(event):
    try:
        match = re.match(r'\.transfer\s+@?(\w+)\s+(\d+)', event.raw_text)
        if not match:
            await event.edit("Format: .transfer @username count")
            return
        
        username = match.group(1)
        gift_count = int(match.group(2))
        
        if gift_count <= 0:
            await event.edit("Count must be > 0")
            return
        
        await event.edit(f"Searching @{username}...")
        
        try:
            user = await client.get_entity(username)
        except:
            await event.edit(f"User @{username} not found")
            return
        
        await event.edit(f"Loading gifts...")
        
        try:
            me = await client.get_me()
            saved_gifts = await client(functions.payments.GetSavedStarGiftsRequest(
                peer=me,
                offset='',
                limit=100,
                exclude_unsaved=False,
                exclude_saved=False,
                exclude_unlimited=False,
                exclude_unique=False,
                sort_by_value=False,
                exclude_upgradable=False,
                exclude_unupgradable=False
            ))
            
            if not saved_gifts.gifts:
                await event.edit("No gifts available")
                return
            
            current_time = int(time.time())
            available_gifts = []
            
            for gift in saved_gifts.gifts:
                if hasattr(gift, 'refunded') and gift.refunded:
                    continue
                if hasattr(gift, 'can_transfer_at') and gift.can_transfer_at:
                    if current_time < gift.can_transfer_at:
                        continue
                available_gifts.append(gift)
            
            if not available_gifts:
                await event.edit(f"No available gifts from {len(saved_gifts.gifts)}")
                return
            
            print(f"\nFirst 3 gifts:")
            for idx, g in enumerate(available_gifts[:3]):
                print(f"{idx+1}. msg_id={getattr(g, 'msg_id', None)}, saved_id={getattr(g, 'saved_id', None)}")
            
            await event.edit(
                f"Total: {len(saved_gifts.gifts)}\n"
                f"Available: {len(available_gifts)}\n"
                f"Transferring {min(gift_count, len(available_gifts))}..."
            )
            
            success = 0
            failed = 0
            paid_transfers = 0
            
            user_input_peer = await client.get_input_entity(user)
            
            for i in range(min(gift_count, len(available_gifts))):
                gift = available_gifts[i]
                ok = False
                
                needs_payment = hasattr(gift, 'transfer_stars') and gift.transfer_stars and gift.transfer_stars > 0
                
                if needs_payment:
                    try:
                        if hasattr(gift, 'saved_id') and gift.saved_id:
                            stargift = types.InputSavedStarGiftChat(peer=me, saved_id=gift.saved_id)
                        elif hasattr(gift, 'msg_id') and gift.msg_id:
                            stargift = types.InputSavedStarGiftUser(msg_id=gift.msg_id)
                        else:
                            continue
                        
                        payment_form = await client(functions.payments.GetPaymentFormRequest(
                            invoice=types.InputInvoiceStarGiftTransfer(
                                stargift=stargift,
                                to_id=user_input_peer
                            )
                        ))
                        
                        result = await client(functions.payments.SendStarsFormRequest(
                            form_id=payment_form.form_id,
                            invoice=types.InputInvoiceStarGiftTransfer(
                                stargift=stargift,
                                to_id=user_input_peer
                            )
                        ))
                        
                        success += 1
                        paid_transfers += 1
                        ok = True
                        print(f"Gift {i+1} transferred with payment {gift.transfer_stars} stars")
                        await asyncio.sleep(0.5)
                    except Exception as e:
                        print(f"Gift {i+1} payment skipped: {e}")
                        continue
                
                else:
                    if hasattr(gift, 'saved_id') and gift.saved_id:
                        try:
                            await client(functions.payments.TransferStarGiftRequest(
                                stargift=types.InputSavedStarGiftChat(peer=me, saved_id=gift.saved_id),
                                to_id=user_input_peer
                            ))
                            success += 1
                            ok = True
                            print(f"Gift {i+1} transferred free (saved_id)")
                            await asyncio.sleep(0.5)
                        except Exception as e:
                            print(f"Gift {i+1} saved_id error: {e}")
                    
                    if not ok and hasattr(gift, 'msg_id') and gift.msg_id:
                        try:
                            await client(functions.payments.TransferStarGiftRequest(
                                stargift=types.InputSavedStarGiftUser(msg_id=gift.msg_id),
                                to_id=user_input_peer
                            ))
                            success += 1
                            ok = True
                            print(f"Gift {i+1} transferred free (msg_id)")
                            await asyncio.sleep(0.5)
                        except Exception as e:
                            print(f"Gift {i+1} msg_id error: {e}")
                    
                    if not ok:
                        failed += 1
            
            if success > 0:
                msg = f"Transferred: {success}\n"
                if paid_transfers > 0:
                    msg += f"Paid: {paid_transfers}\n"
                if failed > 0:
                    msg += f"Failed: {failed}\n"
                msg += f"To: @{username}\nID: {user.id}"
                await event.edit(msg)
            else:
                await event.edit(f"Failed to transfer {failed} gifts")
                
        except Exception as e:
            await event.edit(f"Error: {str(e)}")
        
    except ValueError:
        await event.edit("Count must be a number")
    except Exception as e:
        await event.edit(f"Error: {str(e)}")

async def main():
    print("Starting bot on test server...")
    print(f"DC:{DC_SERVER['dc_id']} {DC_SERVER['ip']}:{DC_SERVER['port']}")
    print(f"Session: gift_bot_session.session")
    
    await client.connect()
    
    if not await client.is_user_authorized():
        print("Sending code...")
        await client.send_code_request(PHONE)
        code = input('Code: ')
        try:
            await client.sign_in(PHONE, code)
        except SessionPasswordNeededError:
            password = input('2FA password: ')
            await client.sign_in(password=password)
    
    me = await client.get_me()
    print(f"Started")
    print(f"Account: {me.first_name} (@{me.username or 'none'})")
    print(f"ID: {me.id}")
    print(f"Command: .transfer @username count")
    
    await client.run_until_disconnected()

if __name__ == '__main__':
    asyncio.run(main())
