<?php

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;
use Automattic\WooCommerce\StoreApi\Payments\PaymentContext;
use Automattic\WooCommerce\StoreApi\Payments\PaymentResult;

class WC_Yabetoopay_Gateway_Blocks_Support extends AbstractPaymentMethodType
{

  /**
   * Payment method name/id/slug.
   *
   * @var string
   */
  protected $name = 'yabetoopay-gateway';

  /**
   * Initialize the payment method type.
   */
  public function initialize()
  {
    $this->settings = get_option("woocommerce_{$this->name}_settings", []);
    add_action('woocommerce_rest_checkout_process_payment_with_context', array($this, 'failed_payment_notice'), 8, 2);
  }

  /**
   * Returns if this payment method should be active. If false, the scripts will not be enqueued.
   *
   * @return boolean
   */
  public function is_active()
  {
    return !empty($this->settings['enabled']) && 'yes' === $this->settings['enabled'];
  }

  /**
   * Returns the assets to be enqueued.
   */
  public function get_payment_method_script_handles()

  {
    $script_asset_path = plugins_url('build/index.asset.php', WC_YABETOOPAY_MAIN_FILE);
    $script_asset      = file_exists($script_asset_path)
      ? require $script_asset_path
      : array(
        'dependencies' => array(),
        'version'      => WC_YABETOOPAY_VERSION,
      );

    $script_url = plugins_url('build/index.js', WC_YABETOOPAY_MAIN_FILE);
    wp_register_script(
      'wc-yabetoopay-gateway-blocks-integration',
      $script_url,
      $script_asset['dependencies'],
      $script_asset['version'],
      true
    );

    return array('wc-yabetoopay-gateway-blocks-integration');
  }

  /**
   * Returns an array of key=>value pairs of data made available to the payment methods script.
   *
   * @return array
   */
  public function get_payment_method_data()
  {
    $payment_gateways_class = WC()->payment_gateways();
    $payment_gateways       = $payment_gateways_class->payment_gateways();
    $gateway                = $payment_gateways['yabetoopay-gateway'];

    return array(
      'title'             => $this->get_setting('title'),
      'description'       => $this->get_setting('description'),
      'icon'              => plugins_url('assets/img/yabetoopay.svg', WC_YABETOOPAY_MAIN_FILE) . '?ver=' . WC_YABETOOPAY_VERSION,
      'supports'          => array_filter($gateway->supports, array($gateway, 'supports')),
    );
  }


  /**
   * Add failed payment notice to the payment details.
   *
   * @param PaymentContext $context Holds context for the payment.
   * @param PaymentResult  $result  Result object for the payment.
   */
  public function failed_payment_notice(PaymentContext $context, PaymentResult &$result)
  {
    if ('yabetoopay-gateway' === $context->payment_method) {
      add_action(
        'wc_gateway_yabetoopay-gateway_process_payment_error',
        function ($failed_notice) use (&$result) {
          $payment_details                 = $result->payment_details;
          $payment_details['errorMessage'] = wp_strip_all_tags($failed_notice);
          $result->set_payment_details($payment_details);
        }
      );
    }
  }
}
