<?php

/**
 * Plugin Name: Yabetoopay Gateway
 * Plugin URI: https://wordpress.org/plugins/yabetoopay-gateway
 * Description: Yabetoopay allows businesses to safely receive payments by mobile money.
 * Author: Yabetoopay Developer Team ❤️
 * Author URI: https://yabetoopay.com/
 * License: GPLv2
 * Version: 1.0.0
 * Requires at least: 6.0
 * Tested up to: 6.7
 * WC requires at least: 6.0
 * WC tested up to: 6.7
 * Text Domain: yabetoopay-gateway
 */

define('WC_YABETOOPAY_MAIN_FILE', __FILE__);
define('WC_YABETOOPAY_VERSION', '1.0.0');

if (file_exists(__DIR__ . '/vendor/autoload.php')) {
  require_once __DIR__ . '/vendor/autoload.php';
}

// Make sure WooCommerce is active
if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins'))))
  return;

/*
 * The class itself, please note that it is inside plugins_loaded action hook
 */
function yabetoopay_init_gateway_class()
{
  if (!class_exists('WC_Payment_Gateway'))
    return;
  require_once(plugin_dir_path(__FILE__) . 'includes/class-wc-yabetoopay-gateway.php');

  add_filter('woocommerce_payment_gateways', 'yabetoopay_add_gateway_class');

  /*
     * This action hook registers our PHP class as a WooCommerce payment gateway
     */
  function yabetoopay_add_gateway_class($gateways)
  {
    $gateways[] = 'WC_Yabetoopay_Gateway';
    return $gateways;
  }

  // Enregistrer les hooks pour le callback et le webhook
  add_action('woocommerce_api_wc_yabetoopay_gateway', 'yabetoopay_handle_callback');
  add_action('woocommerce_api_wc_yabetoopay_gateway_webhook', 'yabetoopay_handle_webhook');
}

/**
 * Fonction pour gérer le callback
 */
function yabetoopay_handle_callback()
{
  $gateway = new WC_Yabetoopay_Gateway();
  $gateway->handle_callback();
}

/**
 * Fonction pour gérer le webhook
 */
function yabetoopay_handle_webhook()
{
  $gateway = new WC_Yabetoopay_Gateway();
  $gateway->handle_webhook();
}

add_action('plugins_loaded', 'yabetoopay_init_gateway_class');

/**
 * Declare the HPOS compatibility
 */
add_action(
  'before_woocommerce_init',
  function () {
    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
      \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
    if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
      \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility(
        'cart_checkout_blocks',
        __FILE__,
        true
      );
    }
  }
);

/**
 * Registers WooCommerce Blocks integration.
 */
function yabetoopay_gateway_woocommerce_block_support()
{

  if (class_exists(\Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType::class)) {

    require_once __DIR__ . '/includes/class-wc-yabetoopay-gateway-blocks-support.php';

    add_action(
      'woocommerce_blocks_payment_method_type_registration',
      static function (Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry) {
        $payment_method_registry->register(new WC_Yabetoopay_Gateway_Blocks_Support());
      }
    );
  }
}
add_action('woocommerce_blocks_loaded', 'yabetoopay_gateway_woocommerce_block_support');
