<?php
/**
 * Plugin Name:       HumAi Job Posting
 * Plugin URI:        https://www.humaiwebsitesukltd.co.uk/our-wordpress-contributions/humai-job-posting
 * Description:       A comprehensive job posting plugin for WordPress with employer dashboard and PDF application support.
 * Version:           1.0.0
 * Author:            HumAi Webs
 * Author URI:        https://www.humaiwebsitesukltd.co.uk/
 * License:           GPLv2 or later
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       humai-job-posting
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Current plugin version.
 */
define( 'HUMAI_JOB_POSTING_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 */
function activate_humai_job_posting() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-humai-job-activator.php';
	HumAi_Job_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 */
function deactivate_humai_job_posting() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-humai-job-deactivator.php';
	HumAi_Job_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_humai_job_posting' );
register_deactivation_hook( __FILE__, 'deactivate_humai_job_posting' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-humai-job-posting.php';

/**
 * Begins execution of the plugin.
 */
function run_humai_job_posting() {
	$plugin = new HumAi_Job_Posting();
	$plugin->run();
}
run_humai_job_posting();
