<?php

class HumAi_Job_Admin {

	private $plugin_name;
	private $version;

	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	public function enqueue_styles() {
		// wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/humai-job-admin.css', array(), $this->version, 'all' );
	}

	public function enqueue_scripts() {
		// wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/humai-job-admin.js', array( 'jquery' ), $this->version, false );
	}



	public function display_plugin_setup_page() {
		?>
		<div class="wrap">
			<h1><?php _e( 'HumAi Job Posting - Help & Shortcodes', 'humai-job-posting' ); ?></h1>
			
			<div class="card">
				<h2><?php _e( 'Available Shortcodes', 'humai-job-posting' ); ?></h2>
				
				<table class="form-table" role="presentation">
					<tbody>
						<tr>
							<th scope="row"><code>[humai_jobs]</code></th>
							<td>
								<p><?php _e( 'Displays the list of latest job postings with a search form.', 'humai-job-posting' ); ?></p>
								<p><strong><?php _e( 'Attributes:', 'humai-job-posting' ); ?></strong></p>
								<ul>
									<li><code>posts_per_page="10"</code> - <?php _e( 'Number of jobs to show per page (default: 10).', 'humai-job-posting' ); ?></li>
								</ul>
								<p><em><?php _e( 'Example:', 'humai-job-posting' ); ?></em> <code>[humai_jobs posts_per_page="5"]</code></p>
							</td>
						</tr>
						<tr>
							<th scope="row"><code>[humai_employer_dashboard]</code></th>
							<td>
								<p><?php _e( 'Displays the frontend dashboard for employers to manage their posted jobs.', 'humai-job-posting' ); ?></p>
							</td>
						</tr>
					</tbody>
				</table>
			</div>

			<div class="card">
				<h2><?php _e( 'Customization Guide', 'humai-job-posting' ); ?></h2>
				<p><?php _e( 'You can customize the application form fields using the <code>humai_job_application_fields</code> filter in your theme functions.', 'humai-job-posting' ); ?></p>
			</div>
		</div>
		<?php
	}

	public function add_plugin_admin_menu() {
		add_submenu_page(
			'edit.php?post_type=job_listing',
			__( 'Help & Shortcodes', 'humai-job-posting' ),
			__( 'Help & Shortcodes', 'humai-job-posting' ),
			'manage_options',
			'humai-job-help',
			array( $this, 'display_plugin_setup_page' )
		);
		
		add_submenu_page(
			'edit.php?post_type=job_listing',
			__( 'Form Editor', 'humai-job-posting' ),
			__( 'Form Editor', 'humai-job-posting' ),
			'manage_options',
			'humai-job-form-editor',
			array( $this, 'display_form_editor_page' )
		);
	}

	public function display_form_editor_page() {
		// Handle Save
		if ( isset( $_POST['humai_save_form_fields'] ) && check_admin_referer( 'humai_save_form_fields_nonce' ) ) {
			if ( ! empty( $_POST['fields'] ) ) {
				$sanitized_fields = array();
				foreach ( $_POST['fields'] as $key => $field ) {
					// Use specific keys enabled in the UI
					if ( ! empty( $field['key'] ) ) {
						$field_key = sanitize_title( $field['key'] );
						$sanitized_fields[ $field_key ] = array(
							'label'    => sanitize_text_field( $field['label'] ),
							'type'     => sanitize_text_field( $field['type'] ),
							'required' => isset( $field['required'] ),
						);
					}
				}
				update_option( 'humai_job_form_settings', $sanitized_fields );
				echo '<div class="notice notice-success is-dismissible"><p>' . __( 'Form fields saved successfully.', 'humai-job-posting' ) . '</p></div>';
			}
		}

		// Get current fields or defaults
		$saved_fields = get_option( 'humai_job_form_settings', array() );
		
		// If empty, populate with defaults for display
		if ( empty( $saved_fields ) ) {
			$saved_fields = array(
				'applicant_name' => array( 'label' => 'Full Name', 'type' => 'text', 'required' => true ),
				'applicant_email' => array( 'label' => 'Email Address', 'type' => 'email', 'required' => true ),
				'applicant_message' => array( 'label' => 'Cover Letter / Message', 'type' => 'textarea', 'required' => false ),
				'applicant_cv' => array( 'label' => 'Upload CV', 'type' => 'file', 'required' => true ),
			);
		}
		?>
		<div class="wrap">
			<h1><?php _e( 'Application Form Editor', 'humai-job-posting' ); ?></h1>
			<p><?php _e( 'Customize the fields that appear on the job application form.', 'humai-job-posting' ); ?></p>
			
			<form method="post" action="">
				<?php wp_nonce_field( 'humai_save_form_fields_nonce', 'humai_save_form_fields' ); ?>
				
				<table class="widefat fixed striped" id="humai-fields-table">
					<thead>
						<tr>
							<th style="width: 20%;"><?php _e( 'Field Key (Unique)', 'humai-job-posting' ); ?></th>
							<th style="width: 30%;"><?php _e( 'Label', 'humai-job-posting' ); ?></th>
							<th style="width: 20%;"><?php _e( 'Type', 'humai-job-posting' ); ?></th>
							<th style="width: 10%;"><?php _e( 'Required', 'humai-job-posting' ); ?></th>
							<th style="width: 10%;"><?php _e( 'Actions', 'humai-job-posting' ); ?></th>
						</tr>
					</thead>
					<tbody id="humai-fields-body">
						<?php 
						$index = 0;
						foreach ( $saved_fields as $key => $field ) : 
						?>
						<tr class="field-row">
							<td><input type="text" name="fields[<?php echo $index; ?>][key]" value="<?php echo esc_attr( $key ); ?>" class="regular-text" required ></td>
							<td><input type="text" name="fields[<?php echo $index; ?>][label]" value="<?php echo esc_attr( $field['label'] ); ?>" class="regular-text" required></td>
							<td>
								<select name="fields[<?php echo $index; ?>][type]">
									<option value="text" <?php selected( $field['type'], 'text' ); ?>>Text</option>
									<option value="email" <?php selected( $field['type'], 'email' ); ?>>Email</option>
									<option value="textarea" <?php selected( $field['type'], 'textarea' ); ?>>Textarea</option>
									<option value="file" <?php selected( $field['type'], 'file' ); ?>>File Select</option>
								</select>
							</td>
							<td><input type="checkbox" name="fields[<?php echo $index; ?>][required]" <?php checked( ! empty( $field['required'] ) ); ?>></td>
							<td><button type="button" class="button humai-remove-field">Remove</button></td>
						</tr>
						<?php 
						$index++;
						endforeach; 
						?>
					</tbody>
				</table>
				
				<p>
					<button type="button" class="button" id="humai-add-field"><?php _e( '+ Add Field', 'humai-job-posting' ); ?></button>
				</p>
				
				<hr>
				<p>
					<button type="submit" class="button button-primary"><?php _e( 'Save Form Fields', 'humai-job-posting' ); ?></button>
				</p>
			</form>
			
			<script>
				jQuery(document).ready(function($) {
					var fieldIndex = <?php echo $index; ?>;
					
					$('#humai-add-field').on('click', function() {
						var html = '<tr class="field-row">';
						html += '<td><input type="text" name="fields[' + fieldIndex + '][key]" class="regular-text" required placeholder="e.g. phone_number"></td>';
						html += '<td><input type="text" name="fields[' + fieldIndex + '][label]" class="regular-text" required placeholder="Label"></td>';
						html += '<td><select name="fields[' + fieldIndex + '][type]"><option value="text">Text</option><option value="email">Email</option><option value="textarea">Textarea</option><option value="file">File Select</option></select></td>';
						html += '<td><input type="checkbox" name="fields[' + fieldIndex + '][required]"></td>';
						html += '<td><button type="button" class="button humai-remove-field">Remove</button></td>';
						html += '</tr>';
						
						$('#humai-fields-body').append(html);
						fieldIndex++;
					});
					
					$(document).on('click', '.humai-remove-field', function() {
						$(this).closest('tr').remove();
					});
				});
			</script>
		</div>
		<?php
	}
	
	public function add_meta_boxes() {
		add_meta_box(
			'humai_job_application_actions',
			__( 'Actions', 'humai-job-posting' ),
			array( $this, 'render_application_actions_meta_box' ),
			'job_application',
			'side',
			'high'
		);
	}
	
	public function render_application_actions_meta_box( $post ) {
		$print_url = admin_url( 'admin-post.php?action=humai_print_application&post_id=' . $post->ID );
		?>
		<div class="misc-pub-section">
			<a href="<?php echo esc_url( $print_url ); ?>" target="_blank" class="button button-primary button-large" style="width: 100%; text-align: center;">
				<?php _e( 'Download / Print Application', 'humai-job-posting' ); ?>
			</a>
		</div>
		<?php
	}
	
	public function handle_print_application() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( __( 'Unauthorized access.', 'humai-job-posting' ) );
		}
		
		$post_id = isset( $_GET['post_id'] ) ? intval( $_GET['post_id'] ) : 0;
		if ( ! $post_id ) {
			wp_die( __( 'Invalid Post ID.', 'humai-job-posting' ) );
		}
		
		$post = get_post( $post_id );
		if ( ! $post || $post->post_type !== 'job_application' ) {
			wp_die( __( 'Application not found.', 'humai-job-posting' ) );
		}
		
		$applicant_name = get_post_meta( $post_id, '_applicant_name', true );
		$applicant_email = get_post_meta( $post_id, '_applicant_email', true );
		$applicant_cv = get_post_meta( $post_id, '_applicant_cv', true );
		$job_id = get_post_meta( $post_id, '_job_applied_for', true );
		$job_title = get_the_title( $job_id );
		$application_data = get_post_meta( $post_id, '_humai_application_data', true );
		
		?>
		<!DOCTYPE html>
		<html lang="en">
		<head>
			<meta charset="UTF-8">
			<meta name="viewport" content="width=device-width, initial-scale=1.0">
			<title><?php printf( __( 'Application: %s', 'humai-job-posting' ), $applicant_name ); ?></title>
			<style>
				body { font-family: Arial, sans-serif; line-height: 1.6; max-width: 800px; margin: 40px auto; padding: 20px; }
				h1 { border-bottom: 2px solid #333; padding-bottom: 10px; }
				.meta-info { background: #f9f9f9; padding: 15px; border-radius: 5px; margin-bottom: 20px; }
				.meta-item { margin-bottom: 10px; }
				.label { font-weight: bold; width: 150px; display: inline-block; }
				.content { white-space: pre-wrap; margin-bottom: 30px; }
				.footer { margin-top: 50px; font-size: 0.8em; color: #666; border-top: 1px solid #ddd; padding-top: 10px; }
				@media print {
					.no-print { display: none; }
				}
			</style>
		</head>
		<body>
			<button onclick="window.print()" class="no-print" style="padding: 10px 20px; font-size: 16px; margin-bottom: 20px; cursor: pointer;">🖨️ Print / Save as PDF</button>
			
			<h1><?php _e( 'Job Application', 'humai-job-posting' ); ?></h1>
			
			<div class="meta-info">
				<div class="meta-item"><span class="label"><?php _e( 'Applicant Name:', 'humai-job-posting' ); ?></span> <?php echo esc_html( $applicant_name ); ?></div>
				<div class="meta-item"><span class="label"><?php _e( 'Applicant Email:', 'humai-job-posting' ); ?></span> <?php echo esc_html( $applicant_email ); ?></div>
				<div class="meta-item"><span class="label"><?php _e( 'Job Applied For:', 'humai-job-posting' ); ?></span> <?php echo esc_html( $job_title ); ?></div>
				<div class="meta-item"><span class="label"><?php _e( 'Date:', 'humai-job-posting' ); ?></span> <?php echo get_the_date( '', $post ); ?></div>
			</div>
			
			<h3><?php _e( 'Application Details', 'humai-job-posting' ); ?></h3>
			<div class="content">
				<?php 
				if ( ! empty( $application_data ) && is_array( $application_data ) ) {
					foreach ( $application_data as $key => $value ) {
						// Skip standard fields we already showed
						if ( in_array( $key, array( 'applicant_name', 'applicant_email' ) ) ) continue;
						
						$label = ucfirst( str_replace( '_', ' ', $key ) );
						echo '<p><strong>' . esc_html( $label ) . ':</strong> ' . esc_html( $value ) . '</p>';
					}
				} else {
					echo esc_html( $post->post_content );
				}
				?>
			</div>
			
			<?php if ( $applicant_cv ) : ?>
			<div class="meta-info">
				<strong><?php _e( 'Attached CV/Resume:', 'humai-job-posting' ); ?></strong><br>
				<a href="<?php echo esc_url( $applicant_cv ); ?>"><?php echo esc_html( $applicant_cv ); ?></a>
			</div>
			<?php endif; ?>
			
			<div class="footer">
				<p>Generated by HumAi Job Posting Plugin</p>
			</div>
			
			<script>
				// Auto-trigger print
				// window.print(); 
			</script>
		</body>
		</html>
		<?php
		exit;
	}

}
