<?php

/**
 * Fired during plugin activation
 */
class HumAi_Job_Activator {

	public static function activate() {
		// Trigger CPT registration so flush_rewrite_rules works
		require_once plugin_dir_path( __FILE__ ) . 'class-humai-job-cpt.php';
		$cpt = new HumAi_Job_CPT();
		$cpt->register_post_type();
		$cpt->register_taxonomies();
		
		self::add_roles();

		if ( ! wp_next_scheduled( 'humai_daily_event' ) ) {
			wp_schedule_event( time(), 'daily', 'humai_daily_event' );
		}

		flush_rewrite_rules();
	}

	private static function add_roles() {
		add_role( 'employer', __( 'Employer', 'humai-job-posting' ), array(
			'read'          => true,
			'upload_files'  => true,
			'edit_posts'    => true, // Allow editing their own posts (mapped to jobs later)
			'publish_posts' => true,
			'delete_posts'  => true,
		) );

		add_role( 'applicant', __( 'Applicant', 'humai-job-posting' ), array(
			'read' => true,
		) );
	}

}
