<?php

class HumAi_Job_CPT {

	public function register_post_type() {
		$labels = array(
			'name'                  => _x( 'Jobs', 'Post Type General Name', 'humai-job-posting' ),
			'singular_name'         => _x( 'Job', 'Post Type Singular Name', 'humai-job-posting' ),
			'menu_name'             => __( 'Job Listings', 'humai-job-posting' ),
			'name_admin_bar'        => __( 'Job', 'humai-job-posting' ),
			'archives'              => __( 'Job Archives', 'humai-job-posting' ),
			'attributes'            => __( 'Job Attributes', 'humai-job-posting' ),
			'parent_item_colon'     => __( 'Parent Job:', 'humai-job-posting' ),
			'all_items'             => __( 'All Jobs', 'humai-job-posting' ),
			'add_new_item'          => __( 'Add New Job', 'humai-job-posting' ),
			'add_new'               => __( 'Add New', 'humai-job-posting' ),
			'new_item'              => __( 'New Job', 'humai-job-posting' ),
			'edit_item'             => __( 'Edit Job', 'humai-job-posting' ),
			'update_item'           => __( 'Update Job', 'humai-job-posting' ),
			'view_item'             => __( 'View Job', 'humai-job-posting' ),
			'view_items'            => __( 'View Jobs', 'humai-job-posting' ),
			'search_items'          => __( 'Search Job', 'humai-job-posting' ),
			'not_found'             => __( 'Not found', 'humai-job-posting' ),
			'not_found_in_trash'    => __( 'Not found in Trash', 'humai-job-posting' ),
			'featured_image'        => __( 'Featured Image', 'humai-job-posting' ),
			'set_featured_image'    => __( 'Set featured image', 'humai-job-posting' ),
			'remove_featured_image' => __( 'Remove featured image', 'humai-job-posting' ),
			'use_featured_image'    => __( 'Use as featured image', 'humai-job-posting' ),
			'insert_into_item'      => __( 'Insert into job', 'humai-job-posting' ),
			'uploaded_to_this_item' => __( 'Uploaded to this job', 'humai-job-posting' ),
			'items_list'            => __( 'Jobs list', 'humai-job-posting' ),
			'items_list_navigation' => __( 'Jobs list navigation', 'humai-job-posting' ),
			'filter_items_list'     => __( 'Filter jobs list', 'humai-job-posting' ),
		);
		$args = array(
			'label'                 => __( 'Job', 'humai-job-posting' ),
			'description'           => __( 'Job Listings', 'humai-job-posting' ),
			'labels'                => $labels,
			'supports'              => array( 'title', 'editor', 'thumbnail', 'custom-fields' ),
			'taxonomies'            => array( 'job_category', 'job_type' ),
			'hierarchical'          => false,
			'public'                => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'menu_position'         => 5,
			'menu_icon'             => 'dashicons-businessman',
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'can_export'            => true,
			'has_archive'           => true,
			'exclude_from_search'   => false,
			'publicly_queryable'    => true,
			'capability_type'       => 'post',
		);
		register_post_type( 'job_listing', $args );

		// Job Application CPT
		$labels_app = array(
			'name'                  => _x( 'Applications', 'Post Type General Name', 'humai-job-posting' ),
			'singular_name'         => _x( 'Application', 'Post Type Singular Name', 'humai-job-posting' ),
			'menu_name'             => __( 'Applications', 'humai-job-posting' ),
			'name_admin_bar'        => __( 'Application', 'humai-job-posting' ),
			'archives'              => __( 'Application Archives', 'humai-job-posting' ),
			'attributes'            => __( 'Application Attributes', 'humai-job-posting' ),
			'parent_item_colon'     => __( 'Parent Application:', 'humai-job-posting' ),
			'all_items'             => __( 'All Applications', 'humai-job-posting' ),
			'add_new_item'          => __( 'Add New Application', 'humai-job-posting' ),
			'add_new'               => __( 'Add New', 'humai-job-posting' ),
			'new_item'              => __( 'New Application', 'humai-job-posting' ),
			'edit_item'             => __( 'Edit Application', 'humai-job-posting' ),
			'update_item'           => __( 'Update Application', 'humai-job-posting' ),
			'view_item'             => __( 'View Application', 'humai-job-posting' ),
			'view_items'            => __( 'View Applications', 'humai-job-posting' ),
			'search_items'          => __( 'Search Application', 'humai-job-posting' ),
		);
		$args_app = array(
			'label'                 => __( 'Application', 'humai-job-posting' ),
			'description'           => __( 'Job Applications', 'humai-job-posting' ),
			'labels'                => $labels_app,
			'supports'              => array( 'title', 'editor', 'custom-fields' ),
			'hierarchical'          => false,
			'public'                => false, // Not public
			'show_ui'               => true,
			'show_in_menu'          => 'edit.php?post_type=job_listing', // Submenu of Jobs
			'menu_position'         => 5,
			'show_in_admin_bar'     => false,
			'show_in_nav_menus'     => false,
			'can_export'            => true,
			'has_archive'           => false,
			'exclude_from_search'   => true,
			'publicly_queryable'    => false,
			'capability_type'       => 'post',
		);
		register_post_type( 'job_application', $args_app );
	}

	public function register_taxonomies() {
		// Job Category
		$labels_cat = array(
			'name'                       => _x( 'Job Categories', 'Taxonomy General Name', 'humai-job-posting' ),
			'singular_name'              => _x( 'Job Category', 'Taxonomy Singular Name', 'humai-job-posting' ),
			'menu_name'                  => __( 'Categories', 'humai-job-posting' ),
			'all_items'                  => __( 'All Categories', 'humai-job-posting' ),
			'parent_item'                => __( 'Parent Category', 'humai-job-posting' ),
			'parent_item_colon'          => __( 'Parent Category:', 'humai-job-posting' ),
			'new_item_name'              => __( 'New Category Name', 'humai-job-posting' ),
			'add_new_item'               => __( 'Add New Category', 'humai-job-posting' ),
			'edit_item'                  => __( 'Edit Category', 'humai-job-posting' ),
			'update_item'                => __( 'Update Category', 'humai-job-posting' ),
			'view_item'                  => __( 'View Category', 'humai-job-posting' ),
			'separate_items_with_commas' => __( 'Separate categories with commas', 'humai-job-posting' ),
			'add_or_remove_items'        => __( 'Add or remove categories', 'humai-job-posting' ),
			'choose_from_most_used'      => __( 'Choose from the most used', 'humai-job-posting' ),
			'popular_items'              => __( 'Popular Categories', 'humai-job-posting' ),
			'search_items'               => __( 'Search Categories', 'humai-job-posting' ),
			'not_found'                  => __( 'Not Found', 'humai-job-posting' ),
		);
		$args_cat = array(
			'labels'                     => $labels_cat,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
		);
		register_taxonomy( 'job_category', array( 'job_listing' ), $args_cat );

		// Job Type
		$labels_type = array(
			'name'                       => _x( 'Job Types', 'Taxonomy General Name', 'humai-job-posting' ),
			'singular_name'              => _x( 'Job Type', 'Taxonomy Singular Name', 'humai-job-posting' ),
			'menu_name'                  => __( 'Job Types', 'humai-job-posting' ),
			'all_items'                  => __( 'All Job Types', 'humai-job-posting' ),
			'parent_item'                => __( 'Parent Job Type', 'humai-job-posting' ),
			'parent_item_colon'          => __( 'Parent Job Type:', 'humai-job-posting' ),
			'new_item_name'              => __( 'New Job Type Name', 'humai-job-posting' ),
			'add_new_item'               => __( 'Add New Job Type', 'humai-job-posting' ),
			'edit_item'                  => __( 'Edit Job Type', 'humai-job-posting' ),
			'update_item'                => __( 'Update Job Type', 'humai-job-posting' ),
			'view_item'                  => __( 'View Job Type', 'humai-job-posting' ),
			'separate_items_with_commas' => __( 'Separate job types with commas', 'humai-job-posting' ),
			'add_or_remove_items'        => __( 'Add or remove job types', 'humai-job-posting' ),
			'choose_from_most_used'      => __( 'Choose from the most used', 'humai-job-posting' ),
			'popular_items'              => __( 'Popular Job Types', 'humai-job-posting' ),
			'search_items'               => __( 'Search Job Types', 'humai-job-posting' ),
			'not_found'                  => __( 'Not Found', 'humai-job-posting' ),
		);
		$args_type = array(
			'labels'                     => $labels_type,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
		);
		register_taxonomy( 'job_type', array( 'job_listing' ), $args_type );
	}

}
