<?php

class HumAi_Job_Fields {

	public function add_meta_boxes() {
		add_meta_box(
			'humai_job_details',
			__( 'Job Details', 'humai-job-posting' ),
			array( $this, 'render_meta_box' ),
			'job_listing',
			'normal',
			'high'
		);
	}

	public function render_meta_box( $post ) {
		wp_nonce_field( 'humai_job_save_meta_box_data', 'humai_job_meta_box_nonce' );

		$location = get_post_meta( $post->ID, '_humai_job_location', true );
		$salary = get_post_meta( $post->ID, '_humai_job_salary', true );
		$deadline = get_post_meta( $post->ID, '_humai_job_deadline', true );
		$application_email = get_post_meta( $post->ID, '_humai_job_application_email', true );

		?>
		<p>
			<label for="humai_job_location"><?php _e( 'Location', 'humai-job-posting' ); ?></label>
			<input type="text" id="humai_job_location" name="humai_job_location" value="<?php echo esc_attr( $location ); ?>" class="widefat">
		</p>
		<p>
			<label for="humai_job_salary"><?php _e( 'Salary', 'humai-job-posting' ); ?></label>
			<input type="text" id="humai_job_salary" name="humai_job_salary" value="<?php echo esc_attr( $salary ); ?>" class="widefat">
		</p>
		<p>
			<label for="humai_job_deadline"><?php _e( 'Application Deadline', 'humai-job-posting' ); ?></label>
			<input type="date" id="humai_job_deadline" name="humai_job_deadline" value="<?php echo esc_attr( $deadline ); ?>" class="widefat">
		</p>
		<p>
			<label for="humai_job_application_email"><?php _e( 'Application Email', 'humai-job-posting' ); ?></label>
			<input type="email" id="humai_job_application_email" name="humai_job_application_email" value="<?php echo esc_attr( $application_email ); ?>" class="widefat">
		</p>
		<?php
	}

	public function save_meta_box_data( $post_id ) {
		if ( ! isset( $_POST['humai_job_meta_box_nonce'] ) ) {
			return;
		}

		if ( ! wp_verify_nonce( $_POST['humai_job_meta_box_nonce'], 'humai_job_save_meta_box_data' ) ) {
			return;
		}

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}

		if ( isset( $_POST['humai_job_location'] ) ) {
			update_post_meta( $post_id, '_humai_job_location', sanitize_text_field( $_POST['humai_job_location'] ) );
		}
		if ( isset( $_POST['humai_job_salary'] ) ) {
			update_post_meta( $post_id, '_humai_job_salary', sanitize_text_field( $_POST['humai_job_salary'] ) );
		}
		if ( isset( $_POST['humai_job_deadline'] ) ) {
			update_post_meta( $post_id, '_humai_job_deadline', sanitize_text_field( $_POST['humai_job_deadline'] ) );
		}
		if ( isset( $_POST['humai_job_application_email'] ) ) {
			update_post_meta( $post_id, '_humai_job_application_email', sanitize_email( $_POST['humai_job_application_email'] ) );
		}
	}

}
