<?php

/**
 * The core plugin class.
 */
class HumAi_Job_Posting {

	protected $loader;
	protected $plugin_name;
	protected $version;

	public function __construct() {
		if ( defined( 'HUMAI_JOB_POSTING_VERSION' ) ) {
			$this->version = HUMAI_JOB_POSTING_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'humai-job-posting';

		$this->load_dependencies();
		$this->define_admin_hooks();
		$this->define_public_hooks();
	}

	private function load_dependencies() {
		require_once plugin_dir_path( __FILE__ ) . 'class-humai-job-loader.php';
		require_once plugin_dir_path( __FILE__ ) . 'class-humai-job-cpt.php';
		require_once plugin_dir_path( __FILE__ ) . 'class-humai-job-fields.php';
		require_once plugin_dir_path( __FILE__ ) . 'admin/class-humai-job-admin.php';
		require_once plugin_dir_path( __FILE__ ) . 'public/class-humai-job-public.php';
		require_once plugin_dir_path( __FILE__ ) . 'public/class-humai-job-dashboard.php';

		$this->loader = new HumAi_Job_Loader();
	}

	private function define_admin_hooks() {
		$plugin_admin = new HumAi_Job_Admin( $this->get_plugin_name(), $this->get_version() );
		$cpt = new HumAi_Job_CPT();
		$fields = new HumAi_Job_Fields();

		$this->loader->add_action( 'init', $cpt, 'register_post_type' );
		$this->loader->add_action( 'init', $cpt, 'register_taxonomies' );
		
		$this->loader->add_action( 'add_meta_boxes', $fields, 'add_meta_boxes' );
		$this->loader->add_action( 'add_meta_boxes', $plugin_admin, 'add_meta_boxes' ); // Action column
		$this->loader->add_action( 'save_post', $fields, 'save_meta_box_data' );
		
		// PDF/Print Action
		$this->loader->add_action( 'admin_post_humai_print_application', $plugin_admin, 'handle_print_application' );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
		$this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_admin_menu' );
		
		// Cron Event
		$this->loader->add_action( 'humai_daily_event', $this, 'check_job_expiry' );
	}

	public function check_job_expiry() {
		$args = array(
			'post_type'      => 'job_listing',
			'post_status'    => 'publish',
			'posts_per_page' => -1,
			'meta_query'     => array(
				array(
					'key'     => '_humai_job_deadline',
					'value'   => date( 'Y-m-d' ),
					'compare' => '<',
					'type'    => 'DATE',
				),
			),
		);

		$query = new WP_Query( $args );

		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				$query->the_post();
				$update_args = array(
					'ID'          => get_the_ID(),
					'post_status' => 'draft',
				);
				wp_update_post( $update_args );
			}
			wp_reset_postdata();
		}
	}

	private function define_public_hooks() {
		$plugin_public = new HumAi_Job_Public( $this->get_plugin_name(), $this->get_version() );
		$plugin_dashboard = new HumAi_Job_Dashboard( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );
		
		// Template Filter
		$this->loader->add_filter( 'single_template', $plugin_public, 'load_single_template' );

		// Form Submission
		$this->loader->add_action( 'admin_post_humai_submit_application', $plugin_public, 'handle_application_submission' );
		$this->loader->add_action( 'admin_post_nopriv_humai_submit_application', $plugin_public, 'handle_application_submission' );

		// Dashboard Actions
		$this->loader->add_action( 'admin_post_humai_save_job', $plugin_dashboard, 'handle_save_job' );
		$this->loader->add_action( 'admin_post_humai_delete_job', $plugin_dashboard, 'handle_delete_job' );

		// Shortcodes
		$this->loader->add_shortcode( 'humai_jobs', $plugin_public, 'render_jobs_shortcode' );
		$this->loader->add_shortcode( 'humai_employer_dashboard', $plugin_dashboard, 'render_dashboard_shortcode' );
	}

	public function run() {
		$this->loader->run();
	}

	public function get_plugin_name() {
		return $this->plugin_name;
	}

	public function get_version() {
		return $this->version;
	}

}
