<?php
get_header(); ?>

<div class="humai-job-single-container">
	<?php
	while ( have_posts() ) :
		the_post();
		
		$location = get_post_meta( get_the_ID(), '_humai_job_location', true );
		$salary = get_post_meta( get_the_ID(), '_humai_job_salary', true );
		$deadline = get_post_meta( get_the_ID(), '_humai_job_deadline', true );
		$application_email = get_post_meta( get_the_ID(), '_humai_job_application_email', true );
		?>

		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<header class="entry-header">
				<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
				
				<div class="humai-job-meta-single">
					<?php if ( $location ) : ?>
						<div class="meta-item"><strong><?php _e( 'Location:', 'humai-job-posting' ); ?></strong> <?php echo esc_html( $location ); ?></div>
					<?php endif; ?>
					
					<?php if ( $salary ) : ?>
						<div class="meta-item"><strong><?php _e( 'Salary:', 'humai-job-posting' ); ?></strong> <?php echo esc_html( $salary ); ?></div>
					<?php endif; ?>

					<?php if ( $deadline ) : ?>
						<div class="meta-item"><strong><?php _e( 'Deadline:', 'humai-job-posting' ); ?></strong> <?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $deadline ) ) ); ?></div>
					<?php endif; ?>

					<div class="meta-item">
						<strong><?php _e( 'Type:', 'humai-job-posting' ); ?></strong>
						<?php echo get_the_term_list( get_the_ID(), 'job_type', '', ', ' ); ?>
					</div>
					
					<div class="meta-item">
						<strong><?php _e( 'Category:', 'humai-job-posting' ); ?></strong>
						<?php echo get_the_term_list( get_the_ID(), 'job_category', '', ', ' ); ?>
					</div>
				</div>
			</header>

			<div class="entry-content">
				<?php the_content(); ?>
			</div>

			<div class="humai-application-section">
				<h3><?php _e( 'Apply for this Job', 'humai-job-posting' ); ?></h3>
				
				<?php if ( isset( $_GET['application_sent'] ) && $_GET['application_sent'] === 'true' ) : ?>
					<div class="humai-alert humai-alert-success">
						<?php _e( 'Thank you! Your application has been submitted successfully.', 'humai-job-posting' ); ?>
					</div>
				<?php endif; ?>
				
				<form action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" method="post" enctype="multipart/form-data" class="humai-application-form">
					<input type="hidden" name="action" value="humai_submit_application">
					<input type="hidden" name="job_id" value="<?php echo get_the_ID(); ?>">
					<?php wp_nonce_field( 'humai_application_submit', 'humai_application_nonce' ); ?>
					
					<!-- Honeypot -->
					<div style="display:none;">
						<label for="humai_honeypot">Leave this field empty</label>
						<input type="text" name="humai_honeypot" id="humai_honeypot">
					</div>

					<?php
					$fields = HumAi_Job_Public::get_application_fields( get_the_ID() );
					
					foreach ( $fields as $key => $field ) : 
						$required = ! empty( $field['required'] ) ? 'required' : '';
						$label = $field['label'] . ( ! empty( $field['required'] ) ? ' *' : '' );
						?>
						<p>
							<label for="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $label ); ?></label>
							
							<?php if ( $field['type'] === 'textarea' ) : ?>
								<textarea name="<?php echo esc_attr( $key ); ?>" id="<?php echo esc_attr( $key ); ?>" rows="5" <?php echo $required; ?>></textarea>
							
							<?php elseif ( $field['type'] === 'select' ) : ?>
								<select name="<?php echo esc_attr( $key ); ?>" id="<?php echo esc_attr( $key ); ?>" <?php echo $required; ?>>
									<?php foreach ( $field['options'] as $opt_val => $opt_label ) : ?>
										<option value="<?php echo esc_attr( $opt_val ); ?>"><?php echo esc_html( $opt_label ); ?></option>
									<?php endforeach; ?>
								</select>
							
							<?php else : ?>
								<input type="<?php echo esc_attr( $field['type'] ); ?>" name="<?php echo esc_attr( $key ); ?>" id="<?php echo esc_attr( $key ); ?>" <?php echo $required; ?> <?php if( isset( $field['accept'] ) ) echo 'accept="' . esc_attr( $field['accept'] ) . '"'; ?>>
							
							<?php endif; ?>
						</p>
					<?php endforeach; ?>

					<p>
						<button type="submit" class="humai-btn"><?php _e( 'Submit Application', 'humai-job-posting' ); ?></button>
					</p>
				</form>
			</div>

		</article>

	<?php endwhile; ?>
</div>

<?php
get_footer();
