<?php
/**
 * Plugin Name:       Humera Job Board
 * Plugin URI:        https://www.humaiwebsitesukltd.co.uk/our-wordpress-contributions/humera-job-board
 * Description:       A comprehensive job posting plugin for WordPress with employer dashboard and PDF application support.
 * Version:           1.0.0
 * Author:            Humera
 * Author URI:        https://www.humaiwebsitesukltd.co.uk/
 * License:           GPLv2 or later
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       humera-job-board
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Current plugin version.
 */
define( 'HUMERA_JOB_BOARD_VERSION', '1.0.0' );
define( 'HUMERA_JOB_BOARD_URL', plugin_dir_url( __FILE__ ) );
define( 'HUMERA_JOB_BOARD_PATH', plugin_dir_path( __FILE__ ) );


/**
 * The code that runs during plugin activation.
 */
function activate_humera_job_board() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-humera-job-activator.php';
	Humera_Job_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 */
function deactivate_humera_job_board() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-humera-job-deactivator.php';
	Humera_Job_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_humera_job_board' );
register_deactivation_hook( __FILE__, 'deactivate_humera_job_board' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-humera-job-board.php';

/**
 * Begins execution of the plugin.
 */
function run_humera_job_board() {
	$plugin = new Humera_Job_Board();
	$plugin->run();
}
run_humera_job_board();
