<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * The core plugin class.
 */
class Humera_Job_Board {

	protected $loader;
	protected $plugin_name;
	protected $version;

	public function __construct() {
		if ( defined( 'HUMERA_JOB_BOARD_VERSION' ) ) {
			$this->version = HUMERA_JOB_BOARD_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'humera-job-board';

		$this->load_dependencies();
		$this->define_admin_hooks();
		$this->define_public_hooks();
	}

	private function load_dependencies() {
		require_once plugin_dir_path( __FILE__ ) . 'class-humera-job-loader.php';
		require_once plugin_dir_path( __FILE__ ) . 'class-humera-job-cpt.php';
		require_once plugin_dir_path( __FILE__ ) . 'class-humera-job-fields.php';
		require_once plugin_dir_path( __FILE__ ) . 'admin/class-humera-job-admin.php';
		require_once plugin_dir_path( __FILE__ ) . 'public/class-humera-job-public.php';
		require_once plugin_dir_path( __FILE__ ) . 'public/class-humera-job-dashboard.php';

		$this->loader = new Humera_Job_Loader();
	}

	private function define_admin_hooks() {
		$plugin_admin = new Humera_Job_Admin( $this->get_plugin_name(), $this->get_version() );
		$cpt = new Humera_Job_CPT();
		$fields = new Humera_Job_Fields();

		$this->loader->add_action( 'init', $cpt, 'register_post_type' );
		$this->loader->add_action( 'init', $cpt, 'register_taxonomies' );
		
		$this->loader->add_action( 'add_meta_boxes', $fields, 'add_meta_boxes' );
		$this->loader->add_action( 'add_meta_boxes', $plugin_admin, 'add_meta_boxes' ); // Action column
		$this->loader->add_action( 'save_post', $fields, 'save_meta_box_data' );
		
		// PDF/Print Action
		$this->loader->add_action( 'admin_post_humera_print_application', $plugin_admin, 'handle_print_application' );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
		$this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_admin_menu' );
		
		// Cron Event
		$this->loader->add_action( 'humera_daily_event', $this, 'check_job_expiry' );
		
		// Menu Notification
		$this->loader->add_action( 'admin_menu', $plugin_admin, 'add_application_counts_to_menu', 99 );

		// Admin Row Actions and Export
		$this->loader->add_filter( 'post_row_actions', $plugin_admin, 'customize_post_row_actions', 10, 2 );
		$this->loader->add_action( 'manage_posts_extra_tablenav', $plugin_admin, 'add_export_button' );
		$this->loader->add_action( 'admin_post_humera_export_applications', $plugin_admin, 'handle_export_applications' );
	}

	public function check_job_expiry() {
		$args = array(
			'post_type'      => 'job_listing',
			'post_status'    => 'publish',
			'posts_per_page' => -1,
			'meta_query'     => array(
				array(
					'key'     => '_humera_job_deadline',
					'value'   => gmdate( 'Y-m-d' ),
					'compare' => '<',
					'type'    => 'DATE',
				),
			),
		);

		$query = new WP_Query( $args );

		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				$query->the_post();
				$update_args = array(
					'ID'          => get_the_ID(),
					'post_status' => 'draft',
				);
				wp_update_post( $update_args );
			}
			wp_reset_postdata();
		}
	}

	private function define_public_hooks() {
		$plugin_public = new Humera_Job_Public( $this->get_plugin_name(), $this->get_version() );
		$plugin_dashboard = new Humera_Job_Dashboard( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );
		
		// Template Filter
		$this->loader->add_filter( 'single_template', $plugin_public, 'load_single_template' );

		// Form Submission
		$this->loader->add_action( 'admin_post_humera_submit_application', $plugin_public, 'handle_application_submission' );
		$this->loader->add_action( 'admin_post_nopriv_humera_submit_application', $plugin_public, 'handle_application_submission' );

		// Dashboard Actions
		$this->loader->add_action( 'admin_post_humera_save_job', $plugin_dashboard, 'handle_save_job' );
		$this->loader->add_action( 'admin_post_humera_delete_job', $plugin_dashboard, 'handle_delete_job' );

		// Shortcodes
		$this->loader->add_shortcode( 'humera_jobs', $plugin_public, 'render_jobs_shortcode' );
		$this->loader->add_shortcode( 'humera_employer_dashboard', $plugin_dashboard, 'render_dashboard_shortcode' );
	}

	public function run() {
		$this->loader->run();
	}

	public function get_plugin_name() {
		return $this->plugin_name;
	}

	public function get_version() {
		return $this->version;
	}

}
