<?php

class Humera_Job_CPT {

	public function register_post_type() {
		$labels = array(
			'name'                  => _x( 'Jobs', 'Post Type General Name', 'humera-job-board' ),
			'singular_name'         => _x( 'Job', 'Post Type Singular Name', 'humera-job-board' ),
			'menu_name'             => __( 'Job Listings', 'humera-job-board' ),
			'name_admin_bar'        => __( 'Job', 'humera-job-board' ),
			'archives'              => __( 'Job Archives', 'humera-job-board' ),
			'attributes'            => __( 'Job Attributes', 'humera-job-board' ),
			'parent_item_colon'     => __( 'Parent Job:', 'humera-job-board' ),
			'all_items'             => __( 'All Jobs', 'humera-job-board' ),
			'add_new_item'          => __( 'Add New Job', 'humera-job-board' ),
			'add_new'               => __( 'Add New', 'humera-job-board' ),
			'new_item'              => __( 'New Job', 'humera-job-board' ),
			'edit_item'             => __( 'Edit Job', 'humera-job-board' ),
			'update_item'           => __( 'Update Job', 'humera-job-board' ),
			'view_item'             => __( 'View Job', 'humera-job-board' ),
			'view_items'            => __( 'View Jobs', 'humera-job-board' ),
			'search_items'          => __( 'Search Job', 'humera-job-board' ),
			'not_found'             => __( 'Not found', 'humera-job-board' ),
			'not_found_in_trash'    => __( 'Not found in Trash', 'humera-job-board' ),
			'featured_image'        => __( 'Featured Image', 'humera-job-board' ),
			'set_featured_image'    => __( 'Set featured image', 'humera-job-board' ),
			'remove_featured_image' => __( 'Remove featured image', 'humera-job-board' ),
			'use_featured_image'    => __( 'Use as featured image', 'humera-job-board' ),
			'insert_into_item'      => __( 'Insert into job', 'humera-job-board' ),
			'uploaded_to_this_item' => __( 'Uploaded to this job', 'humera-job-board' ),
			'items_list'            => __( 'Jobs list', 'humera-job-board' ),
			'items_list_navigation' => __( 'Jobs list navigation', 'humera-job-board' ),
			'filter_items_list'     => __( 'Filter jobs list', 'humera-job-board' ),
		);
		$args = array(
			'label'                 => __( 'Job', 'humera-job-board' ),
			'description'           => __( 'Job Listings', 'humera-job-board' ),
			'labels'                => $labels,
			'supports'              => array( 'title', 'editor', 'thumbnail', 'custom-fields' ),
			'taxonomies'            => array( 'job_category', 'job_type' ),
			'hierarchical'          => false,
			'public'                => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'menu_position'         => 5,
			'menu_icon'             => 'dashicons-businessman',
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'can_export'            => true,
			'has_archive'           => true,
			'exclude_from_search'   => false,
			'publicly_queryable'    => true,
			'capability_type'       => 'post',
		);
		register_post_type( 'job_listing', $args );

		// Job Application CPT
		$labels_app = array(
			'name'                  => _x( 'Applications', 'Post Type General Name', 'humera-job-board' ),
			'singular_name'         => _x( 'Application', 'Post Type Singular Name', 'humera-job-board' ),
			'menu_name'             => __( 'Applications', 'humera-job-board' ),
			'name_admin_bar'        => __( 'Application', 'humera-job-board' ),
			'archives'              => __( 'Application Archives', 'humera-job-board' ),
			'attributes'            => __( 'Application Attributes', 'humera-job-board' ),
			'parent_item_colon'     => __( 'Parent Application:', 'humera-job-board' ),
			'all_items'             => __( 'All Applications', 'humera-job-board' ),
			'add_new_item'          => __( 'Add New Application', 'humera-job-board' ),
			'add_new'               => __( 'Add New', 'humera-job-board' ),
			'new_item'              => __( 'New Application', 'humera-job-board' ),
			'edit_item'             => __( 'Edit Application', 'humera-job-board' ),
			'update_item'           => __( 'Update Application', 'humera-job-board' ),
			'view_item'             => __( 'View Application', 'humera-job-board' ),
			'view_items'            => __( 'View Applications', 'humera-job-board' ),
			'search_items'          => __( 'Search Application', 'humera-job-board' ),
		);
		$args_app = array(
			'label'                 => __( 'Application', 'humera-job-board' ),
			'description'           => __( 'Job Applications', 'humera-job-board' ),
			'labels'                => $labels_app,
			'supports'              => array( 'title', 'editor', 'custom-fields' ),
			'hierarchical'          => false,
			'public'                => false, // Not public
			'show_ui'               => true,
			'show_in_menu'          => 'edit.php?post_type=job_listing', // Submenu of Jobs
			'menu_position'         => 5,
			'show_in_admin_bar'     => false,
			'show_in_nav_menus'     => false,
			'can_export'            => true,
			'has_archive'           => false,
			'exclude_from_search'   => true,
			'publicly_queryable'    => false,
			'capability_type'       => 'post',
		);
		register_post_type( 'job_application', $args_app );
	}

	public function register_taxonomies() {
		// Job Category
		$labels_cat = array(
			'name'                       => _x( 'Job Categories', 'Taxonomy General Name', 'humera-job-board' ),
			'singular_name'              => _x( 'Job Category', 'Taxonomy Singular Name', 'humera-job-board' ),
			'menu_name'                  => __( 'Categories', 'humera-job-board' ),
			'all_items'                  => __( 'All Categories', 'humera-job-board' ),
			'parent_item'                => __( 'Parent Category', 'humera-job-board' ),
			'parent_item_colon'          => __( 'Parent Category:', 'humera-job-board' ),
			'new_item_name'              => __( 'New Category Name', 'humera-job-board' ),
			'add_new_item'               => __( 'Add New Category', 'humera-job-board' ),
			'edit_item'                  => __( 'Edit Category', 'humera-job-board' ),
			'update_item'                => __( 'Update Category', 'humera-job-board' ),
			'view_item'                  => __( 'View Category', 'humera-job-board' ),
			'separate_items_with_commas' => __( 'Separate categories with commas', 'humera-job-board' ),
			'add_or_remove_items'        => __( 'Add or remove categories', 'humera-job-board' ),
			'choose_from_most_used'      => __( 'Choose from the most used', 'humera-job-board' ),
			'popular_items'              => __( 'Popular Categories', 'humera-job-board' ),
			'search_items'               => __( 'Search Categories', 'humera-job-board' ),
			'not_found'                  => __( 'Not Found', 'humera-job-board' ),
		);
		$args_cat = array(
			'labels'                     => $labels_cat,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
		);
		register_taxonomy( 'job_category', array( 'job_listing' ), $args_cat );

		// Job Type
		$labels_type = array(
			'name'                       => _x( 'Job Types', 'Taxonomy General Name', 'humera-job-board' ),
			'singular_name'              => _x( 'Job Type', 'Taxonomy Singular Name', 'humera-job-board' ),
			'menu_name'                  => __( 'Job Types', 'humera-job-board' ),
			'all_items'                  => __( 'All Job Types', 'humera-job-board' ),
			'parent_item'                => __( 'Parent Job Type', 'humera-job-board' ),
			'parent_item_colon'          => __( 'Parent Job Type:', 'humera-job-board' ),
			'new_item_name'              => __( 'New Job Type Name', 'humera-job-board' ),
			'add_new_item'               => __( 'Add New Job Type', 'humera-job-board' ),
			'edit_item'                  => __( 'Edit Job Type', 'humera-job-board' ),
			'update_item'                => __( 'Update Job Type', 'humera-job-board' ),
			'view_item'                  => __( 'View Job Type', 'humera-job-board' ),
			'separate_items_with_commas' => __( 'Separate job types with commas', 'humera-job-board' ),
			'add_or_remove_items'        => __( 'Add or remove job types', 'humera-job-board' ),
			'choose_from_most_used'      => __( 'Choose from the most used', 'humera-job-board' ),
			'popular_items'              => __( 'Popular Job Types', 'humera-job-board' ),
			'search_items'               => __( 'Search Job Types', 'humera-job-board' ),
			'not_found'                  => __( 'Not Found', 'humera-job-board' ),
		);
		$args_type = array(
			'labels'                     => $labels_type,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
		);
		register_taxonomy( 'job_type', array( 'job_listing' ), $args_type );
	}

}
