<?php

class Humera_Job_Fields {

	public function add_meta_boxes() {
		add_meta_box(
			'humera_job_details',
			__( 'Job Details', 'humera-job-board' ),
			array( $this, 'render_meta_box' ),
			'job_listing',
			'normal',
			'high'
		);
	}

	public function render_meta_box( $post ) {
		wp_nonce_field( 'humera_job_save_meta_box_data', 'humera_job_meta_box_nonce' );

		$location = get_post_meta( $post->ID, '_humera_job_location', true );
		$salary = get_post_meta( $post->ID, '_humera_job_salary', true );
		$deadline = get_post_meta( $post->ID, '_humera_job_deadline', true );
		$application_email = get_post_meta( $post->ID, '_humera_job_application_email', true );

		?>
		<p>
			<label for="humera_job_location"><?php esc_html_e( 'Location', 'humera-job-board' ); ?></label>
			<input type="text" id="humera_job_location" name="humera_job_location" value="<?php echo esc_attr( $location ); ?>" class="widefat">
		</p>
		<p>
			<label for="humera_job_salary"><?php esc_html_e( 'Salary', 'humera-job-board' ); ?></label>
			<input type="text" id="humera_job_salary" name="humera_job_salary" value="<?php echo esc_attr( $salary ); ?>" class="widefat">
		</p>
		<p>
			<label for="humera_job_deadline"><?php esc_html_e( 'Application Deadline', 'humera-job-board' ); ?></label>
			<input type="date" id="humera_job_deadline" name="humera_job_deadline" value="<?php echo esc_attr( $deadline ); ?>" class="widefat">
		</p>
		<p>
			<label for="humera_job_application_email"><?php esc_html_e( 'Application Email', 'humera-job-board' ); ?></label>
			<input type="email" id="humera_job_application_email" name="humera_job_application_email" value="<?php echo esc_attr( $application_email ); ?>" class="widefat">
		</p>
		<?php
	}

	public function save_meta_box_data( $post_id ) {
		if ( ! isset( $_POST['humera_job_meta_box_nonce'] ) ) {
			return;
		}

		if ( ! wp_verify_nonce( $_POST['humera_job_meta_box_nonce'], 'humera_job_save_meta_box_data' ) ) {
			return;
		}

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}

		if ( isset( $_POST['humera_job_location'] ) ) {
			update_post_meta( $post_id, '_humera_job_location', sanitize_text_field( wp_unslash( $_POST['humera_job_location'] ) ) );
		}
		if ( isset( $_POST['humera_job_salary'] ) ) {
			update_post_meta( $post_id, '_humera_job_salary', sanitize_text_field( wp_unslash( $_POST['humera_job_salary'] ) ) );
		}
		if ( isset( $_POST['humera_job_deadline'] ) ) {
			update_post_meta( $post_id, '_humera_job_deadline', sanitize_text_field( wp_unslash( $_POST['humera_job_deadline'] ) ) );
		}
		if ( isset( $_POST['humera_job_application_email'] ) ) {
			update_post_meta( $post_id, '_humera_job_application_email', sanitize_email( wp_unslash( $_POST['humera_job_application_email'] ) ) );
		}
	}

}
