<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="humera-job-item">
	<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
	<div class="humera-job-meta">
		<?php
		$location = get_post_meta( get_the_ID(), '_humera_job_location', true );
		$types = get_the_term_list( get_the_ID(), 'job_type', '', ', ' );
		
		if ( $location ) {
			echo '<span class="humera-location">' . esc_html( $location ) . '</span>';
		}
		
		if ( $location && $types ) {
			echo ' | ';
		}
		
		if ( $types ) {
			echo '<span class="humera-type">' . $types . '</span>'; // Term list contains links, so no esc_html
		}
		?>
	</div>
	<div class="humera-job-excerpt">
		<?php the_excerpt(); ?>
	</div>
	<div class="humera-job-actions">
		<a href="<?php the_permalink(); ?>" class="humera-btn"><?php esc_html_e( 'View Details', 'humera-job-board' ); ?></a>
	</div>
</div>
