/* Humera Job Board – Public JS */
(function($) {
    'use strict';

    $(document).ready(function() {

        // ── Grid / List View Toggle ──────────────────
        var $listings = $('#humera-job-listings');
        var $btnGrid  = $('#humera-btn-grid');
        var $btnList  = $('#humera-btn-list');

        // Apply stored preference
        var savedView = localStorage.getItem('hjb_view') || 'grid';
        setView(savedView);

        $btnGrid.on('click', function() { setView('grid'); });
        $btnList.on('click', function() { setView('list'); });

        function setView(view) {
            if ('list' === view) {
                $listings.removeClass('humera-job-listings--grid').addClass('humera-job-listings--list');
                $btnList.addClass('active');
                $btnGrid.removeClass('active');
            } else {
                $listings.removeClass('humera-job-listings--list').addClass('humera-job-listings--grid');
                $btnGrid.addClass('active');
                $btnList.removeClass('active');
            }
            localStorage.setItem('hjb_view', view);
        }

        // ── Card hover animation supplement ──────────
        // (CSS handles the transform; JS adds accessible focus ring on keyboard)
        $('.humera-job-item').on('focusin', function() {
            $(this).css('outline', '2px solid var(--hjb-primary)');
        }).on('focusout', function() {
            $(this).css('outline', '');
        });

    });

})(jQuery);
