<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$humera_job_id   = get_the_ID();
$humera_location = get_post_meta( $humera_job_id, '_humera_job_location', true );
$humera_salary   = get_post_meta( $humera_job_id, '_humera_job_salary', true );
$humera_deadline = get_post_meta( $humera_job_id, '_humera_job_deadline', true );
$humera_types    = get_the_terms( $humera_job_id, 'humera_job_type' );
$humera_cats     = get_the_terms( $humera_job_id, 'humera_job_category' );

// "New" badge: posted within last 7 days.
$humera_is_new = ( strtotime( get_the_date( 'Y-m-d' ) ) >= strtotime( '-7 days' ) );

// Deadline countdown.
$humera_days_left = '';
$humera_is_urgent = false;
if ( $humera_deadline ) {
	$humera_diff = ( strtotime( $humera_deadline ) - time() ) / DAY_IN_SECONDS;
	if ( $humera_diff > 0 ) {
		$humera_days_left = (int) ceil( $humera_diff );
		$humera_is_urgent = ( $humera_days_left <= 3 );
	}
}

// Category slug for colour-coded top stripe.
$humera_cat_slug = '';
if ( ! empty( $humera_cats ) && ! is_wp_error( $humera_cats ) ) {
	$humera_cat_slug = $humera_cats[0]->slug;
}

// Deadline badge class.
$humera_deadline_class = 'humera-deadline-badge' . ( $humera_is_urgent ? ' urgent' : '' );
?>
<div class="humera-job-item" data-cat="<?php echo esc_attr( $humera_cat_slug ); ?>">

	<?php if ( $humera_is_new ) : ?>
		<span class="humera-new-badge"><?php esc_html_e( '&#10024; New', 'humera-job-board' ); ?></span>
	<?php endif; ?>

	<div class="humera-job-card-inner">

		<h3><a href="<?php the_permalink(); ?>"><?php echo esc_html( get_the_title() ); ?></a></h3>

		<?php
		$humera_has_types = ( ! empty( $humera_types ) && ! is_wp_error( $humera_types ) );
		$humera_has_cats  = ( ! empty( $humera_cats ) && ! is_wp_error( $humera_cats ) );
		if ( $humera_has_types || $humera_has_cats ) :
		?>
		<div class="humera-job-tags">
			<?php if ( $humera_has_types ) : ?>
				<?php foreach ( $humera_types as $humera_t ) : ?>
					<span class="humera-tag humera-tag--type">&#128188; <?php echo esc_html( $humera_t->name ); ?></span>
				<?php endforeach; ?>
			<?php endif; ?>
			<?php if ( $humera_has_cats ) : ?>
				<?php foreach ( $humera_cats as $humera_c ) : ?>
					<span class="humera-tag humera-tag--category">&#127991; <?php echo esc_html( $humera_c->name ); ?></span>
				<?php endforeach; ?>
			<?php endif; ?>
		</div>
		<?php endif; ?>

		<div class="humera-job-meta">
			<?php if ( $humera_location ) : ?>
				<span class="humera-location">
					<span class="dashicons dashicons-location"></span>
					<?php echo esc_html( $humera_location ); ?>
				</span>
			<?php endif; ?>

			<?php if ( $humera_salary ) : ?>
				<span class="humera-salary-badge">
					<?php echo esc_html( $humera_salary ); ?>
				</span>
			<?php endif; ?>

			<?php if ( $humera_days_left ) : ?>
				<span class="<?php echo esc_attr( $humera_deadline_class ); ?>">
					&#9200; <?php
					echo esc_html(
						sprintf(
							/* translators: %d: number of days remaining until the job application deadline */
							_n( 'Closes in %d day', 'Closes in %d days', $humera_days_left, 'humera-job-board' ),
							$humera_days_left
						)
					);
					?>
				</span>
			<?php endif; ?>
		</div>

		<div class="humera-job-excerpt">
			<?php
			$humera_content = strip_shortcodes( get_the_content() );
			$humera_text    = wp_strip_all_tags( $humera_content );
			$humera_text    = preg_replace( '/^(Location:|Job Type:).*?(\n|\r)/i', '', $humera_text );
			echo esc_html( wp_trim_words( $humera_text, 18, '...' ) );
			?>
		</div>

		<div class="humera-job-actions">
			<a href="<?php the_permalink(); ?>" class="humera-btn">
				<?php esc_html_e( 'View Details', 'humera-job-board' ); ?> &rarr;
			</a>
		</div>

	</div>
</div>
