<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

get_header(); ?>

<div class="humera-job-single-container">
	<?php
	while ( have_posts() ) :
		the_post();
		
		$humera_location = get_post_meta( get_the_ID(), '_humera_job_location', true );
		$humera_salary = get_post_meta( get_the_ID(), '_humera_job_salary', true );
		$humera_deadline = get_post_meta( get_the_ID(), '_humera_job_deadline', true );
		$humera_application_email = get_post_meta( get_the_ID(), '_humera_job_application_email', true );
		?>

		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<header class="entry-header">
				<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
				
				<div class="humera-job-meta-single">
					<?php if ( $humera_location ) : ?>
						<div class="meta-item"><strong><?php esc_html_e( 'Location:', 'humera-job-board' ); ?></strong> <?php echo esc_html( $humera_location ); ?></div>
					<?php endif; ?>
					
					<?php if ( $humera_salary ) : ?>
						<div class="meta-item"><strong><?php esc_html_e( 'Salary:', 'humera-job-board' ); ?></strong> <?php echo esc_html( $humera_salary ); ?></div>
					<?php endif; ?>

					<?php if ( $humera_deadline ) : ?>
						<div class="meta-item"><strong><?php esc_html_e( 'Deadline:', 'humera-job-board' ); ?></strong> <?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $humera_deadline ) ) ); ?></div>
					<?php endif; ?>

					<div class="meta-item">
						<strong><?php esc_html_e( 'Type:', 'humera-job-board' ); ?></strong>
						<?php echo wp_kses_post( get_the_term_list( get_the_ID(), 'humera_job_type', '', ', ' ) ); // Term list contains links ?>
					</div>
					
					<div class="meta-item">
						<strong><?php esc_html_e( 'Category:', 'humera-job-board' ); ?></strong>
						<?php echo wp_kses_post( get_the_term_list( get_the_ID(), 'humera_job_category', '', ', ' ) ); // Term list contains links ?>
					</div>
				</div>
			</header>

			<div class="entry-content">
				<?php the_content(); ?>
			</div>

			<div class="humera-application-section">
				<h3><?php esc_html_e( 'Apply for this Job', 'humera-job-board' ); ?></h3>
				
				<?php if ( isset( $_GET['application_sent'] ) && $_GET['application_sent'] === 'true' ) : // phpcs:ignore WordPress.Security.NonceVerification.Recommended ?>
					<div class="humera-alert humera-alert-success">
						<?php esc_html_e( 'Thank you! Your application has been submitted successfully.', 'humera-job-board' ); ?>
					</div>
				<?php endif; ?>
				
				<form action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" method="post" enctype="multipart/form-data" class="humera-application-form">
					<input type="hidden" name="action" value="humera_submit_application">
					<input type="hidden" name="job_id" value="<?php echo intval( get_the_ID() ); ?>">
					<?php wp_nonce_field( 'humera_application_submit', 'humera_application_nonce' ); ?>
					
					<!-- Honeypot -->
					<div style="display:none;">
						<label for="humera_honeypot"><?php esc_html_e( 'Leave this field empty', 'humera-job-board' ); ?></label>
						<input type="text" name="humera_honeypot" id="humera_honeypot">
					</div>

					<?php
					$humera_fields = Humera_Job_Public::get_application_fields( get_the_ID() );
					
					foreach ( $humera_fields as $humera_key => $humera_field ) : 
						$humera_required = ! empty( $humera_field['required'] ) ? 'required' : '';
						$humera_label = $humera_field['label'] . ( ! empty( $humera_field['required'] ) ? ' *' : '' );
						?>
						<p>
							<label for="<?php echo esc_attr( $humera_key ); ?>"><?php echo esc_html( $humera_label ); ?></label>
							
							<?php if ( $humera_field['type'] === 'textarea' ) : ?>
								<textarea name="<?php echo esc_attr( $humera_key ); ?>" id="<?php echo esc_attr( $humera_key ); ?>" rows="5" <?php echo esc_attr( $humera_required ); ?>></textarea>
							
							<?php elseif ( $humera_field['type'] === 'select' ) : ?>
								<select name="<?php echo esc_attr( $humera_key ); ?>" id="<?php echo esc_attr( $humera_key ); ?>" <?php echo esc_attr( $humera_required ); ?>>
									<?php foreach ( $humera_field['options'] as $humera_opt_val => $humera_opt_label ) : ?>
										<option value="<?php echo esc_attr( $humera_opt_val ); ?>"><?php echo esc_html( $humera_opt_label ); ?></option>
									<?php endforeach; ?>
								</select>
							
							<?php else : ?>
								<input type="<?php echo esc_attr( $humera_field['type'] ); ?>" name="<?php echo esc_attr( $humera_key ); ?>" id="<?php echo esc_attr( $humera_key ); ?>" <?php echo esc_attr( $humera_required ); ?> <?php if( isset( $humera_field['accept'] ) ) echo 'accept="' . esc_attr( $humera_field['accept'] ) . '"'; ?>>
							
							<?php endif; ?>
						</p>
					<?php endforeach; ?>

					<p>
						<button type="submit" class="humera-btn"><?php esc_html_e( 'Submit Application', 'humera-job-board' ); ?></button>
					</p>
				</form>
			</div>

		</article>

	<?php endwhile; ?>
</div>

<?php
get_footer();
